/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;

public abstract class PartTypeConfigurable<P extends IPartType<P, S>, S extends IPartState<P>>
extends PartTypeBase<P, S> {
    public PartTypeConfigurable(String name, PartRenderPosition partRenderPosition) {
        super(name, partRenderPosition);
    }

    @Override
    public Optional<MenuProvider> getContainerProviderSettings(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent(PartTypeConfigurable.this.getTranslationKey());
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                Triple<IPartContainer, PartTypeBase, PartTarget> data = PartHelpers.getContainerPartConstructionData(pos);
                return new ContainerPartSettings(id, playerInventory, (Container)new SimpleContainer(0), (PartTarget)data.getRight(), Optional.of((IPartContainer)data.getLeft()), (IPartType)data.getMiddle());
            }
        });
    }

    @Override
    public void writeExtraGuiDataSettings(FriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        PacketCodec.write((FriendlyByteBuf)packetBuffer, (Object)pos);
        packetBuffer.m_130070_(this.getUniqueName().toString());
    }
}

